/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.base.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.base.request.update.LauncherRequest;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.StdJavaRuntimeProvider;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.utils.LauncherUpdater;
import pro.gravit.utils.helper.LogHelper;

public class LoginScene
extends AbstractScene {
    private List<GetAvailabilityAuthRequestEvent.AuthAvailability> auth;
    private CheckBox savePasswordCheckBox;
    private CheckBox autoenter;
    private Pane content;
    private AbstractVisualComponent contentComponent;
    private LoginAuthButtonComponent authButton;
    private ComboBox<GetAvailabilityAuthRequestEvent.AuthAvailability> authList;
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;
    private final AuthFlow authFlow;

    public LoginScene(JavaFXApplication application) {
        super("scenes/login/login.fxml", application);
        LoginSceneAccessor accessor = new LoginSceneAccessor();
        this.authFlow = new AuthFlow(accessor, this::onSuccessLogin);
    }

    @Override
    public void doInit() {
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.globalSettingsScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.authButton = new LoginAuthButtonComponent((Button)LookupHelper.lookup((Node)this.layout, "#authButton"), this.application, (EventHandler<ActionEvent>)((EventHandler)e -> this.contextHelper.runCallback(this.authFlow::loginWithGui)));
        this.savePasswordCheckBox = (CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword");
        if (this.application.runtimeSettings.password != null || this.application.runtimeSettings.oauthAccessToken != null) {
            ((CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword")).setSelected(true);
        }
        this.autoenter = (CheckBox)LookupHelper.lookup((Node)this.layout, "#autoenter");
        this.autoenter.setSelected(this.application.runtimeSettings.autoAuth);
        this.autoenter.setOnAction(event -> {
            this.application.runtimeSettings.autoAuth = this.autoenter.isSelected();
        });
        this.content = (Pane)LookupHelper.lookup((Node)this.layout, "#content");
        if (this.application.guiModuleConfig.createAccountURL != null) {
            ((Text)LookupHelper.lookup((Node)this.header, "#createAccount")).setOnMouseClicked(e -> this.application.openURL(this.application.guiModuleConfig.createAccountURL));
        }
        if (this.application.guiModuleConfig.forgotPassURL != null) {
            ((Text)LookupHelper.lookup((Node)this.header, "#forgotPass")).setOnMouseClicked(e -> this.application.openURL(this.application.guiModuleConfig.forgotPassURL));
        }
        this.authList = (ComboBox)LookupHelper.lookup((Node)this.layout, "#authList");
        this.authList.setConverter((StringConverter)new AuthAvailabilityStringConverter());
        this.authList.setOnAction(e -> this.changeAuthAvailability((GetAvailabilityAuthRequestEvent.AuthAvailability)this.authList.getSelectionModel().getSelectedItem()));
        this.authFlow.prepare();
    }

    @Override
    protected void doPostInit() {
        if (!this.application.isDebugMode()) {
            this.launcherRequest();
        } else {
            this.getAvailabilityAuth();
        }
    }

    private void launcherRequest() {
        LauncherRequest launcherRequest = new LauncherRequest();
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.launcher"), launcherRequest, result -> {
            if (result.needUpdate) {
                try {
                    LogHelper.debug((String)"Start update processing");
                    this.disable();
                    StdJavaRuntimeProvider.updatePath = LauncherUpdater.prepareUpdate((URL)new URI(result.url).toURL());
                    LogHelper.debug((String)"Exit with Platform.exit");
                    Platform.exit();
                    return;
                }
                catch (Throwable e) {
                    this.contextHelper.runInFxThread(() -> this.errorHandle(e));
                    try {
                        Thread.sleep(1500L);
                        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientExitPhase(0));
                        Platform.exit();
                    }
                    catch (Throwable ex) {
                        LauncherEngine.exitLauncher((int)0);
                    }
                }
            }
            LogHelper.dev((String)"Launcher update processed");
            this.getAvailabilityAuth();
        }, (EventHandler<ActionEvent>)((EventHandler)event -> LauncherEngine.exitLauncher((int)0)));
    }

    private void getAvailabilityAuth() {
        GetAvailabilityAuthRequest getAvailabilityAuthRequest = new GetAvailabilityAuthRequest();
        this.processing((Request)getAvailabilityAuthRequest, this.application.getTranslation("runtime.overlay.processing.text.authAvailability"), auth -> this.contextHelper.runInFxThread(() -> {
            this.auth = auth.list;
            this.authList.setVisible(auth.list.size() != 1);
            this.authList.setManaged(auth.list.size() != 1);
            for (GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability : auth.list) {
                if (!authAvailability.visible) continue;
                if (this.application.runtimeSettings.lastAuth == null) {
                    if (authAvailability.name.equals("std") || this.authAvailability == null) {
                        this.changeAuthAvailability(authAvailability);
                    }
                } else if (authAvailability.name.equals(this.application.runtimeSettings.lastAuth.name)) {
                    this.changeAuthAvailability(authAvailability);
                }
                if (!authAvailability.visible) continue;
                this.addAuthAvailability(authAvailability);
            }
            if (this.authAvailability == null && !auth.list.isEmpty()) {
                this.changeAuthAvailability((GetAvailabilityAuthRequestEvent.AuthAvailability)auth.list.get(0));
            }
            this.runAutoAuth();
        }), null);
    }

    private void runAutoAuth() {
        block3: {
            block2: {
                if (this.application.guiModuleConfig.autoAuth) break block2;
                if (!this.application.runtimeSettings.autoAuth) break block3;
            }
            this.contextHelper.runInFxThread(this.authFlow::loginWithGui);
        }
    }

    public void changeAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        boolean isChanged = this.authAvailability != authAvailability;
        this.authAvailability = authAvailability;
        this.application.authService.setAuthAvailability(authAvailability);
        ((SingleSelectionModel)this.authList.selectionModelProperty().get()).select((Object)authAvailability);
        this.authFlow.init(authAvailability);
        LogHelper.info((String)"Selected auth: %s", (Object[])new Object[]{authAvailability.name});
    }

    public void addAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        this.authList.getItems().add((Object)authAvailability);
        LogHelper.info((String)"Added %s: %s", (Object[])new Object[]{authAvailability.name, authAvailability.displayName});
    }

    public <T extends WebSocketEvent> void processing(Request<T> request, String text, Consumer<T> onSuccess, Consumer<String> onError) {
        this.processRequest(text, request, onSuccess, thr -> onError.accept(thr.getCause().getMessage()), null);
    }

    @Override
    public void errorHandle(Throwable e) {
        super.errorHandle(e);
        this.contextHelper.runInFxThread(() -> this.authButton.setState(LoginAuthButtonComponent.AuthButtonState.ERROR));
    }

    @Override
    public void reset() {
        this.authFlow.reset();
    }

    @Override
    public String getName() {
        return "login";
    }

    private boolean checkSavePasswordAvailable(AuthRequest.AuthPasswordInterface password) {
        if (password instanceof Auth2FAPassword) {
            return false;
        }
        if (password instanceof AuthMultiPassword) {
            return false;
        }
        return this.authAvailability != null && this.authAvailability.details != null && !this.authAvailability.details.isEmpty() && this.authAvailability.details.get(0) instanceof AuthPasswordDetails;
    }

    public void onSuccessLogin(AuthFlow.SuccessAuth successAuth) {
        AuthRequestEvent result = successAuth.requestEvent();
        this.application.authService.setAuthResult(this.authAvailability.name, result);
        boolean savePassword = this.savePasswordCheckBox.isSelected();
        if (savePassword) {
            this.application.runtimeSettings.login = successAuth.recentLogin();
            if (result.oauth == null) {
                LogHelper.warning((String)"Password not saved");
            } else {
                this.application.runtimeSettings.oauthAccessToken = result.oauth.accessToken;
                this.application.runtimeSettings.oauthRefreshToken = result.oauth.refreshToken;
                this.application.runtimeSettings.oauthExpire = Request.getTokenExpiredTime();
                this.application.runtimeSettings.password = null;
            }
            this.application.runtimeSettings.lastAuth = this.authAvailability;
        }
        if (result.playerProfile != null && result.playerProfile.assets != null) {
            try {
                Texture skin = (Texture)result.playerProfile.assets.get("SKIN");
                Texture avatar = (Texture)result.playerProfile.assets.get("AVATAR");
                if (skin != null || avatar != null) {
                    this.application.skinManager.addSkinWithAvatar(result.playerProfile.username, skin != null ? new URI(skin.url) : null, avatar != null ? new URI(avatar.url) : null);
                    this.application.skinManager.getSkin(result.playerProfile.username);
                }
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
        }
        this.contextHelper.runInFxThread(() -> {
            if (this.application.gui.welcomeOverlay.isInit()) {
                this.application.gui.welcomeOverlay.reset();
            }
            this.showOverlay(this.application.gui.welcomeOverlay, (EventHandler<ActionEvent>)((EventHandler)e -> this.application.gui.welcomeOverlay.hide(2000.0, (EventHandler<ActionEvent>)((EventHandler)f -> this.onGetProfiles()))));
        });
    }

    public void onGetProfiles() {
        this.processing((Request)new ProfilesRequest(), this.application.getTranslation("runtime.overlay.processing.text.profiles"), profiles -> {
            this.application.profilesService.setProfilesResult((ProfilesRequestEvent)profiles);
            this.application.runtimeSettings.profiles = profiles.profiles;
            this.contextHelper.runInFxThread(() -> {
                AbstractScene patt0$temp;
                this.application.securityService.startRequest();
                if (this.application.gui.optionsScene != null) {
                    try {
                        this.application.profilesService.loadAll();
                    }
                    catch (Throwable ex) {
                        this.errorHandle(ex);
                    }
                }
                if ((patt0$temp = this.application.getCurrentScene()) instanceof LoginScene) {
                    LoginScene loginScene = (LoginScene)patt0$temp;
                    loginScene.authFlow.isLoginStarted = false;
                }
                this.application.setMainScene(this.application.gui.serverMenuScene);
            });
        }, null);
    }

    public void clearPassword() {
        this.application.runtimeSettings.password = null;
        this.application.runtimeSettings.login = null;
        this.application.runtimeSettings.oauthAccessToken = null;
        this.application.runtimeSettings.oauthRefreshToken = null;
    }

    public AuthFlow getAuthFlow() {
        return this.authFlow;
    }

    public class LoginSceneAccessor
    extends AbstractScene.SceneAccessor {
        public void showContent(AbstractVisualComponent component) throws Exception {
            component.init();
            component.postInit();
            if (LoginScene.this.contentComponent != null) {
                LoginScene.this.content.getChildren().clear();
            }
            LoginScene.this.contentComponent = component;
            LoginScene.this.content.getChildren().add((Object)component.getLayout());
        }

        public LoginAuthButtonComponent getAuthButton() {
            return LoginScene.this.authButton;
        }

        public void setState(LoginAuthButtonComponent.AuthButtonState state) {
            LoginScene.this.authButton.setState(state);
        }

        public boolean isEmptyContent() {
            return LoginScene.this.content.getChildren().isEmpty();
        }

        public void clearContent() {
            LoginScene.this.content.getChildren().clear();
        }

        public <T extends WebSocketEvent> void processing(Request<T> request, String text, Consumer<T> onSuccess, Consumer<String> onError) {
            LoginScene.this.processing(request, text, onSuccess, onError);
        }
    }

    private static class AuthAvailabilityStringConverter
    extends StringConverter<GetAvailabilityAuthRequestEvent.AuthAvailability> {
        private AuthAvailabilityStringConverter() {
        }

        public String toString(GetAvailabilityAuthRequestEvent.AuthAvailability object) {
            return object == null ? "null" : object.displayName;
        }

        public GetAvailabilityAuthRequestEvent.AuthAvailability fromString(String string) {
            return null;
        }
    }
}

